#if 1
#include <functional>
#include <algorithm>
#include <iostream>
#include <iterator>
#include <iomanip>
#include <sstream>
#include <numeric>
#include <string>
#include <vector>
#include <bitset>
#include <queue>
#include <stack>
#include <map>
#include <set>
#include <cstdlib>
#include <cassert>
#include <cstring>
#include <cstdio>
#include <cmath>
#include <ctime>
#include <list>
#include <map>
 
using namespace std;
 
typedef long long LL;
typedef long double LD;
typedef pair<int, int> pii;
 
const LD eps = 1e-9;
const LD pi = acos(-1.0);
const LL inf = 1e+9;
 
#define mp make_pair
#define pb push_back
#define X first
#define Y second
 
#define dbg(x) { cerr << #x << " = " << x << endl; }
 
// extended template
#pragma comment(linker, "/STACK:36777216")
typedef vector<int> vi;
typedef vector<vi> vvi;
 
#define forn(i, n) for (int i = 0; i < n; ++i)
#define all(a) (a).begin(), (a).end()
#define rall(a) (a).rbegin(), (a).rend()
 
template<typename T> istream & operator >> (istream &, vector<T> &);
template<typename T> ostream & operator << (ostream &, const vector<T> &);
 
#define START clock_t _clock = clock();
#define END cerr << endl << "time: " << (clock() - _clock) / LD(CLOCKS_PER_SEC) << endl;
 
#define NAME "problem"

struct edge_t
{
    int u, v;
    LL w;
    edge_t() {}
    edge_t(int u, int v, LL w) : u(u), v(v), w(w) {}
};

int n, m;
vector< vector<edge_t> > g;
vector<LL> d1, d2;

void dijkstra(int s, vector<LL> &dist)
{
    dist.assign(n, -1); dist[s] = 0;

    priority_queue< pair<LL, int> , vector<pair<LL, int> >, greater<pair<LL, int> > > q;
    q.push(mp(LL(0), s));
    
    while (q.size())
    {
        int u = q.top().Y;
        LL  d = q.top().X;
        q.pop();

        if (dist[u] != d)
            continue;
        
        forn(i, g[u].size())
        {
            int v = g[u][i].v;
            LL  d = g[u][i].w;
            if (dist[v] == -1 || dist[v] > dist[u] + d)
            {
                dist[v] = dist[u] + d;
                q.push(mp(dist[v], v));
            }
        }
    }
}

bool check_edge(int u, int v, LL w)
{
    return  d1[u] + d2[u] == d1[n - 1] &&
            d1[v] + d2[v] == d1[n - 1] &&
            (d1[u] + w == d1[v] || d1[v] + w == d1[u]);
}

vvi ng;

vector<int> tin, fup;
int timer = 0;
vector<pii> ans;
vector<int> used;
void dfs(int v, int p = -1)
{
    tin[v] = fup[v] = timer++;
    used[v] = 1;

    for (int i = 0; i < ng[v].size(); i++)
    {
        int to = ng[v][i];
        if (to == p)
            continue;
        if (!used[to])
        {
            dfs(to, v);
            fup[v] = min(fup[v], fup[to]);
        }
        else
        {
            fup[v] = min(fup[v], tin[to]);
        }
        if (fup[to] > tin[v])
            ans.pb(mp(v, to));
    }
}

map<pii, int> conv;

void solve()
{
    scanf("%d %d", &n, &m);
    g.resize(n);
    vector<edge_t> edges(m);
    forn(i, m)
    {
        int u, v, w;
        scanf("%d %d %d", &u, &v, &w);
        --u, --v;
        g[u].push_back(edge_t(u, v, w));
        g[v].push_back(edge_t(v, u, w));
        edges[i] = edge_t(u, v, w);
        conv[mp(u, v)] = conv[mp(v, u)] = i;
    }

    dijkstra(0, d1);
    dijkstra(n - 1, d2);

    ng.resize(n);
    forn(i, m)
    {
        int u = edges[i].u;
        int v = edges[i].v;
        LL  w = edges[i].w;
        if (check_edge(u, v, w))
        {
            ng[u].push_back(v);
            ng[v].push_back(u);
        }
    }

    tin.resize(n);
    fup.resize(n);
    used.assign(n, 0);
    dfs(0);
    printf("%d\n", ans.size());
    
    vi res; res.reserve(ans.size());
    for (int i = 0; i < ans.size(); i++)
        res.push_back(conv[ans[i]] + 1);

    sort(all(res));
    
    forn(i, res.size())
        printf("%d ", res[i]);
    
    printf("\n");
}
 
int main()
{
    // freopen(NAME ".in", "r", stdin); freopen(NAME ".out", "w", stdout);
    //freopen("input.txt", "r", stdin); // freopen("output.txt", "w", stdout);
 
    solve();
 
    return 0;
}
/*******************************************
*******************************************/
 
template<typename T> istream & operator >> (istream &is, vector<T> &v)
{
    forn(i, v.size())
        is >> v[i];
    return is;
}
template<typename T> ostream & operator << (ostream &os, const vector<T> &v)
{
    forn(i, v.size())
        os << v[i] << " ";
    return os;
}
#endif